import { useEditor, useValue } from "@tldraw/editor";
function useShowCollaborationUi() {
  const editor = useEditor();
  return editor.store.props.collaboration !== void 0;
}
function useCollaborationStatus() {
  const editor = useEditor();
  return useValue(
    "sync status",
    () => {
      if (!editor.store.props.collaboration?.status) {
        return null;
      }
      return editor.store.props.collaboration.status.get();
    },
    [editor]
  );
}
export {
  useCollaborationStatus,
  useShowCollaborationUi
};
//# sourceMappingURL=useIsMultiplayer.mjs.map
